// mdNameExample.cpp
//
// Melissa Data mdName API for C++ Windows/Linux/Solaris
// Copyright 1993-2007 Melissa Data Corporation.

//********************************************************************************
//If you should have any comments, suggestions or improvements to these samples,
//we welcome you to contact us at SampleCode@melissadata.com also please visit our
//developers bulletin board at forum.melissadata.com.
//********************************************************************************


#include <stdio.h>
#include <string.h>

#include "mdName.h"

// Change the following lines to reflect your installation location
//   of the mdName API and the license string:
// The Data Files Directory must contain the following files: mdName.dat and mdName.cfg.
#define dFILELOC "C:\\Program Files\\Melissa DATA\\COM Objects\\Data Files"

	/********************** LICENSE STRINGS **********************
	*     To unlock the full functionality of Name Object,       *
	*     	     Or to obtain a Demo License String              *
	* please call a sales representative at 1-800-MELISSA ext. 3 *
	*         (1-800-635-4772 x3) for a license string.          *
	**************************************************************/

#define dLICENSE "DEMO"
int main(int Argc,char *Argv) {
	char FullName[128];
	int Record=0;
	FILE *File;
	mdName *Name;
	Argc;
	Argv;

	// Create and initialize the API:
	Name=new mdName;
	if (!Name->SetLicenseString(dLICENSE)) {
		printf("Error setting License to \"%s\"\n",dLICENSE);
		return 1;
	}
	Name->SetPathToNameFiles(dFILELOC);
	if (Name->InitializeDataFiles()!=mdName::NoError) {
		printf("Error Initializing mdName: \"%s\"\n",
			Name->GetInitializeErrorString());
		return 1;
	}
	// Set a few processing options:
	Name->SetPrimaryNameHint(mdName::NameFull);
	Name->SetSecondaryNameHint(mdName::NameInverse);
	Name->SetFirstNameSpellingCorrection(true);
	Name->SetSalutationPrefix("Dear");
	Name->SetSalutationSuffix(":");
	Name->SetSalutationSlug("Valued Customer");
printf("Could not open mdName.sdf\n");
	// Process the sample data file:
	File=fopen("./mdName.sdf","r");
	if (File==0) {
		printf("Could not open mdName.sdf\n");
		return 1;
	}

	while (fgets(FullName,128,File)!=0) {

		// Trim trailing CR/LFs:
		while (FullName[strlen(FullName)-1]=='\r' || FullName[strlen(FullName)-1]=='\n')
			FullName[strlen(FullName)-1]='\x0';


		Name->ClearProperties();
		Name->SetFullName(FullName);
		Name->Parse();

		printf("Record %d Full Name: %s\n            Gender1: %s\n"
		  "            Prefix1: %s\n        First Name1: %s\n"
		  "       Middle Name1: %s\n         Last Name1: %s\n"
		  "            Suffix1: %s\n            Gender2: %s\n"
		  "            Prefix2: %s\n        First Name2: %s\n"
		  "       Middle Name2: %s\n         Last Name2: %s\n"
		  "            Suffix2: %s\n         Salutation: %s\n\n",
		 ++Record,FullName,Name->GetGender(),
		 Name->GetPrefix(),Name->GetFirstName(),
		 Name->GetMiddleName(),Name->GetLastName(),
		 Name->GetSuffix(),Name->GetGender2(),
		 Name->GetPrefix2(),Name->GetFirstName2(),
		 Name->GetMiddleName2(),Name->GetLastName2(),
		 Name->GetSuffix2(),Name->GetSalutation());
	}
	fclose(File);

	// Free the API:
	delete Name;
	return 0;
}